package it.unicam.pizzeria4.servizio;

import java.util.ArrayList;
import java.util.Iterator;

import it.unicam.pizzeria4.cucina.GestorePreparazione;
import it.unicam.pizzeria4.util.DettagliComanda;

public class GestoreComande {
	
	private static GestoreComande instance;
	
    private static int comandaIndex = 0;
	
    Menu menu;
	GestorePreparazione gPreparazione;
	private ArrayList<Comanda> listaComande;
	
	public GestoreComande() {
		listaComande = new ArrayList<Comanda>();
		menu = Menu.getInstance();
		gPreparazione = GestorePreparazione.getInstance();
	}

	public static GestoreComande getInstance() {
		if (instance == null) {
			instance = new GestoreComande();
		}
		return instance;
	}
	
	public void setGPreparazione(GestorePreparazione gPreparazione) {
		this.gPreparazione = gPreparazione;
	}

	public String newComandaID(int numCoperti) {
		GestoreComande.comandaIndex++;
		String idComanda = Integer.toString(comandaIndex);
		Comanda comanda = new Comanda(idComanda, numCoperti);
		listaComande.add(comanda);
		return idComanda;

	}

	public DettagliComanda getDettagliComanda(String idComanda) {
		Iterator<Comanda> lci = listaComande.iterator();
		Comanda comanda;
		while (lci.hasNext()) {
			comanda = lci.next();
			if (comanda.getID().equals(idComanda)) {
				return comanda.getDettagli();
			}
		}
		System.out.println("[ERROR]: Attenzione non esiste una comanda con ID: " + idComanda);
		return null;
	}

	/**
	 * 
	 * @param idPiatto
	 * @param quantita
	 */
	public void aggiungiPiatto(String idPiatto, int quantita, String idComanda) {
		Piatto piatto = menu.getPiatto(idPiatto);
		if (piatto == null) {
			System.out.println("[ERROR]: Attenzione l'identificativo fornito (" + idPiatto
					+ ")  non corrisponde a nessun piatto. Inserimento nella comanda fallito.");
			return;
		}
		Iterator<Comanda> lci = listaComande.iterator();
		Comanda comanda = null;
		while (lci.hasNext()) {
			comanda = lci.next();
			if (comanda.getID().equals(idComanda)) {
				comanda.aggiungiPortata(piatto, quantita);
				return;
			}			
		}
		System.out.println("[ERROR]: La comanda con ID " + idComanda + " non esiste!");
	}

	/**
	 * 
	 * @param idBibita
	 * @param quantita
	 */
	public void aggiungiBibita(String idBibita, int quantita, String idComanda) {
		Bibita bibita = menu.getBibita(idBibita);
		if (bibita == null) {
			System.out.println("[ERROR]: Attenzione l'identificativo fornito (" + idBibita
					+ ")  non corrisponde a nessuna bibita. Inserimento nella comanda fallito.");
			return;
		}
		Iterator<Comanda> lci = listaComande.iterator();
		Comanda comanda = null;
		while (lci.hasNext()) {
			comanda = lci.next();
			if (comanda.getID().equals(idComanda)) {
				comanda.aggiungiBevanda(bibita, quantita);
				return;
			}			
		}
		System.out.println("[ERROR]: La comanda con ID " + idComanda + " non esiste!");
	}

	public void chiudiCreazioneComanda(String idComanda) {
		Comanda comanda = null;
		Iterator<Comanda> lci = listaComande.iterator();
		while (lci.hasNext()) {
			comanda = lci.next();
			if (comanda.getID().equals(idComanda)) {
				ArrayList<Portata> portate = comanda.getPortate();
				gPreparazione.inserisciCodaPreparazione(portate);
				return;
			}
		}
		System.out.println("[ERROR]: La comanda con ID " + idComanda + " non esiste!");		
	}

}

	

